/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.base;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.base.VWConfigURLTemplateDialog;
import filenet.vw.toolkit.admin.property.base.VWConfigWebApplicationTableModel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWWebAppComboBox;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class VWConfigWebApplicationPanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener,
ActionListener {
    private VWAttributeInfo m_vwAttributeInfo = null;
    private String m_key = null;
    private Dialog m_parentDialog = null;
    private boolean m_bIsDirty = false;
    private Integer m_currentWebApp = null;
    private VWSessionInfo m_vwSessionInfo = null;
    private VWWebAppComboBox m_webAppCombo = null;
    private VWToolbarBorder m_toolBarBorder = null;
    private VWTable m_webServerTable = null;
    private VWConfigWebApplicationTableModel m_tableModel = null;

    public VWConfigWebApplicationPanel(Dialog parentDialog, VWAttributeInfo vwAttributeInfo, VWSessionInfo sessionInfo) {
        this(parentDialog, vwAttributeInfo, sessionInfo, false);
    }

    public VWConfigWebApplicationPanel(Dialog parentDialog, VWAttributeInfo vwAttributeInfo, VWSessionInfo sessionInfo, boolean bIsServiceProperty) {
        try {
            this.m_parentDialog = parentDialog;
            this.m_vwAttributeInfo = vwAttributeInfo;
            this.m_vwSessionInfo = sessionInfo;
            this.createControls(parentDialog, bIsServiceProperty);
            if (this.m_webAppCombo != null && this.m_vwAttributeInfo != null) {
                this.m_key = "F_WebApp";
                this.m_webAppCombo.setSelectedWebApp(this.m_vwAttributeInfo.getFieldValue(this.m_key));
                this.m_currentWebApp = this.m_webAppCombo.getSelectedWebApp();
            }
            this.m_webServerTable.clearSelection();
            if (this.m_webServerTable.getRowCount() > 0) {
                this.m_webServerTable.setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean hasChanged() {
        this.stopTableEditing();
        if (this.m_bIsDirty) {
            return true;
        }
        return this.m_tableModel.hasChanged();
    }

    public boolean stopTableEditing() {
        if (this.m_webServerTable != null) {
            this.m_webServerTable.stopEditing();
        }
        return true;
    }

    public boolean update() {
        if (this.m_webAppCombo != null) {
            try {
                Integer webApp = this.m_webAppCombo.getSelectedWebApp();
                if (webApp == null) {
                    JOptionPane.showMessageDialog(this.m_parentDialog, VWResource.s_invalidWebApp, VWResource.s_error, 0);
                    return false;
                }
                this.m_vwAttributeInfo.setFieldValue(this.m_key, null);
                this.m_vwAttributeInfo.setFieldValue(this.m_key, webApp);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.m_parentDialog, ex.getLocalizedMessage(), VWResource.s_error, 0);
                return false;
            }
        }
        this.stopTableEditing();
        boolean bSuccess = this.m_tableModel.verifySettings();
        if (bSuccess) {
            bSuccess = this.m_tableModel.update();
        }
        return bSuccess;
    }

    public void releaseResources() {
        this.m_vwAttributeInfo = null;
        this.m_key = null;
        this.m_parentDialog = null;
        if (this.m_webAppCombo != null) {
            this.m_webAppCombo.removeActionListener(this);
            this.m_webAppCombo.removeAllItems();
            this.m_webAppCombo = null;
        }
        if (this.m_toolBarBorder != null) {
            this.m_toolBarBorder.releaseReferences();
            this.m_toolBarBorder = null;
        }
        this.m_webServerTable = null;
        if (this.m_tableModel != null) {
            this.m_tableModel.releaseResources();
            this.m_tableModel = null;
        }
        this.removeAll();
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_webServerTable.getSelectedRow()) {
                    this.m_webServerTable.clearSelection();
                }
                this.m_webServerTable.setRowSelectionInterval(nRow, nRow);
                this.m_webServerTable.ensureRowIsVisible(nRow);
                break;
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            int nFirstIndex = this.m_webServerTable.getSelectionModel().getMinSelectionIndex();
            int nLastIndex = this.m_webServerTable.getSelectionModel().getMaxSelectionIndex();
            if (nFirstIndex < this.m_tableModel.getMinimumRowCount() || nLastIndex < this.m_tableModel.getMinimumRowCount()) {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
            } else {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x10000000));
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 16: {
                    this.stopTableEditing();
                    int nRow = this.m_tableModel.getRowCount();
                    this.m_tableModel.addRow();
                    this.m_webServerTable.setRowSelectionInterval(nRow, nRow);
                    this.m_webServerTable.setColumnSelectionInterval(0, 0);
                    this.m_webServerTable.ensureRowIsVisible(nRow);
                    break;
                }
                case 0x10000000: {
                    this.onDeleteRows();
                    break;
                }
                case 131072: {
                    VWConfigURLTemplateDialog dlg = new VWConfigURLTemplateDialog(this.m_parentDialog, this.m_vwAttributeInfo, this.m_vwSessionInfo);
                    dlg.show();
                    if (dlg.getStatus() == 0 && dlg.isModified()) {
                        this.m_bIsDirty = true;
                    }
                    dlg.releaseResources();
                    break;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.m_webAppCombo)) {
            Integer webApp = this.m_webAppCombo.getSelectedWebApp();
            if (webApp != null) {
                if (this.m_currentWebApp == null || this.m_currentWebApp.intValue() != webApp.intValue()) {
                    this.m_currentWebApp = webApp;
                    this.m_bIsDirty = true;
                }
            } else {
                JOptionPane.showMessageDialog(this.m_parentDialog, VWResource.s_invalidWebApp, VWResource.s_error, 0);
            }
        }
    }

    public void createControls(Dialog parentDialog, boolean bIsServiceProperty) {
        try {
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setLayout(new BorderLayout(4, 4));
            this.add((Component)this.createCenterPanel(parentDialog), "Center");
            if (bIsServiceProperty) {
                Color bgColor = this.getBackground();
                JTextArea noteTextArea = new JTextArea();
                noteTextArea.setBackground(bgColor);
                noteTextArea.setEditable(false);
                noteTextArea.setLineWrap(true);
                noteTextArea.setWrapStyleWord(true);
                noteTextArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                this.add((Component)noteTextArea, "Last");
                this.applyComponentOrientation(parentDialog.getComponentOrientation());
                noteTextArea.append(VWResource.NoteSystemWideConfigWebApp);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public JPanel createCenterPanel(Dialog parentDialog) {
        JPanel centerPanel = null;
        try {
            centerPanel = new JPanel();
            centerPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            centerPanel.setLayout(new BorderLayout(4, 4));
            this.createWebServerPanel(parentDialog);
            centerPanel.add((Component)this.m_toolBarBorder, "Center");
            centerPanel.add((Component)this.createWebAppPanel(), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return centerPanel;
    }

    private JPanel createWebAppPanel() {
        JPanel panel = null;
        try {
            panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 4));
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.anchor = 23;
            gbConst.fill = 0;
            gbConst.insets = new Insets(5, 10, 5, 0);
            gbConst.gridx = 0;
            gbConst.gridwidth = 1;
            gbConst.weightx = 0.0;
            gbConst.fill = 0;
            JLabel label = new JLabel(VWResource.s_defaultWebApp);
            panel.add((Component)label, gbConst);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.s_defaultWebApp, VWResource.s_defaultWebApp);
            this.m_webServerTable.addKeyListener(VWKeyAdapter.s_keyAdapter);
            panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.m_webAppCombo = new VWWebAppComboBox(false);
            this.m_webAppCombo.addActionListener(this);
            gbConst.gridx = -1;
            gbConst.gridwidth = 0;
            gbConst.weightx = 1.0;
            gbConst.fill = 2;
            panel.add((Component)this.m_webAppCombo, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_webAppCombo, this, VWResource.s_defaultWebApp, VWResource.s_defaultWebApp);
            VWAccessibilityHelper.setLabelFor(label, this.m_webAppCombo);
            this.m_webAppCombo.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    private void createWebServerPanel(Dialog parentDialog) {
        try {
            this.m_toolBarBorder = new VWToolbarBorder(VWResource.DefaultWebServers, 0x10020010);
            this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
            this.m_tableModel = new VWConfigWebApplicationTableModel(parentDialog, this.m_vwAttributeInfo);
            this.m_tableModel.addTableModelListener(this);
            this.m_webServerTable = new VWTable(this.m_tableModel);
            this.m_webServerTable.setRowSelectionAllowed(true);
            this.m_webServerTable.getSelectionModel().addListSelectionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_webServerTable, this, VWResource.DefaultWebServers, VWResource.DefaultWebServers);
            this.m_webServerTable.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_webServerTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_webServerTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            JPanel panel = this.m_toolBarBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JScrollPane(this.m_webServerTable), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onDeleteRows() {
        try {
            this.stopTableEditing();
            int[] rows = this.m_webServerTable.getSelectedRows();
            for (int nIndex = rows.length - 1; nIndex >= 0; --nIndex) {
                this.m_tableModel.removeRow(rows[nIndex]);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

